
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.Security;

namespace UserAuthenticatedXmlCaching
{

  public enum AuthenticateResult
  {
	  UserPasswordValid,
	  InvalidUser,
	  InvalidPassword
  }
  /// <summary>
  /// Login page.   Automatically shows when user attempts to access
  /// a page that requires authentication.  See ~/web.config for the
  /// settings that make this work.
  /// </summary>
  #region WebForm2
	public class WebForm2 : System.Web.UI.Page
	{
//    protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator1;
//    protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator2;
	 protected System.Web.UI.WebControls.Button Button1;
		protected System.Web.UI.WebControls.Label Msg;
		protected System.Data.DataSet dataSet1;
		protected System.Data.DataTable dataTable1;
		protected System.Data.DataColumn dataColumn1;
		protected System.Data.DataColumn dataColumn2;
		protected int UserRow;
		protected System.Web.UI.WebControls.Label EMailLabel;
		protected System.Web.UI.WebControls.Label PWlLabel;
		protected System.Web.UI.WebControls.TextBox UserEmail;
		protected System.Web.UI.WebControls.TextBox UserPass;
		protected System.Web.UI.WebControls.Button NewUser;

		private void InitializeComponent()
		{
			this.dataSet1 = new System.Data.DataSet();
			this.dataTable1 = new System.Data.DataTable();
			this.dataColumn1 = new System.Data.DataColumn();
			this.dataColumn2 = new System.Data.DataColumn();
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).BeginInit();
			this.Button1.Click += new System.EventHandler(this.Button1_Click);
			this.NewUser.Click += new System.EventHandler(this.NewUser_Click);
			// 
			// dataSet1
			// 
			this.dataSet1.DataSetName = "NewDataSet";
			this.dataSet1.Locale = new System.Globalization.CultureInfo("en-US");
			this.dataSet1.Tables.AddRange(new System.Data.DataTable[] {
						this.dataTable1});
			// 
			// dataTable1
			// 
			this.dataTable1.Columns.AddRange(new System.Data.DataColumn[] {
						this.dataColumn1,
						this.dataColumn2});
			this.dataTable1.TableName = "Users";
			// 
			// dataColumn1
			// 
			this.dataColumn1.ColumnName = "UserEmail";
			// 
			// dataColumn2
			// 
			this.dataColumn2.ColumnName = "Password";
			((System.ComponentModel.ISupportInitialize)(this.dataSet1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dataTable1)).EndInit();
		}

		#region Web Form Designer generated code
		override protected void OnInit(System.EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		#endregion

	  protected AuthenticateResult CheckPassword()
	  {
		  AuthenticateUtils.LoadDataSet(Page, dataSet1);
		  if( !AuthenticateUtils.FindUser(dataSet1, UserEmail.Text.ToLower(), out UserRow) )
			 return AuthenticateResult.InvalidUser;
		  else
		  {
			  string password = dataSet1.Tables[0].Rows[UserRow][1].ToString();
			  if( password == UserPass.Text )
				  return AuthenticateResult.UserPasswordValid;
			  else
				  return AuthenticateResult.InvalidPassword;
		  }
	  }

	  public void Button1_Click(System.Object sender, System.EventArgs e)
	  {
		  AuthenticateResult result = CheckPassword();
		  if( result == AuthenticateResult.UserPasswordValid )
				FormsAuthentication.RedirectFromLoginPage(UserEmail.Text, true);
		  else if( result == AuthenticateResult.InvalidPassword )
		  {
			Msg.Visible = true;
			Msg.Text = UserPass.Text + " not a valid password for user " + UserEmail.Text;
		  }
		  else
		  {
			Msg.Visible = true;
			Msg.Text = "Unknown user " + UserEmail.Text;
		  }
	  }
		
		private void NewUser_Click(object sender, System.EventArgs e)
		{
			AuthenticateUtils.LoadDataSet(Page, dataSet1);
			Msg.Visible = true;
			int Row;
			if( AuthenticateUtils.IsEmpty(UserEmail.Text) ||
				 AuthenticateUtils.IsEmpty(UserPass.Text) )
				Msg.Text = "Must enter valid username and password";
			else if( AuthenticateUtils.FindUser(dataSet1, UserEmail.Text, out Row ) )
				Msg.Text = UserEmail.Text + " already in use";
			else
			{
				AuthenticateUtils.AddEmailAddressAndPassword(Page, dataSet1,
									UserEmail.Text, UserPass.Text);
				FormsAuthentication.SetAuthCookie(UserEmail.Text, true);
				Response.Redirect("~/WebForm1.aspx");
			}
		}
	#endregion

	}

  #region AuthenticateUtils
  public class AuthenticateUtils
  {
	  public static bool FindUser(DataSet dataSet, string EmailAddress, out int row)
	  {
		  row = -1;
		  DataTable table = dataSet.Tables[0];
		  for( int i = 0; i < table.Rows.Count; i++ )
		  {
			  if( (table.Rows[i][0].ToString()).ToLower() == EmailAddress )
			  {
				  row = i;
				  break;
			  }
		  }
		  return row >= 0;
	  }
	  public static void LoadDataSet(Page page, DataSet dataSet)
	  {
		  string UsersXmlFile = AuthenticateUtils.GetXmlFile(page);
		  if( !File.Exists(UsersXmlFile) )
			  dataSet.WriteXml(UsersXmlFile);
		  dataSet.ReadXml(UsersXmlFile);
	  }
	  public static string GetXmlFile(Page page)
	  {
	  	  return page.Request.PhysicalApplicationPath + "\\Users.xml";
	  }
	  public static bool IsEmpty(string s)
	  {
	  	  return (s == null) || (s == "");
	  }
	  public static void AddEmailAddressAndPassword(Page page, DataSet dataSet, string EMailAddress, string Password)
	  {
			DataTable table = dataSet.Tables[0];
			DataRow Row = table.NewRow();
			Row[0] = EMailAddress;
			Row[1] = Password;
			table.Rows.Add(Row);
			table.AcceptChanges();
			dataSet.WriteXml(GetXmlFile(page));
	  }

  }
  #endregion
}

